/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import com.google.common.collect.ImmutableSet;
import forestry.api.core.IErrorLogicSource;
import forestry.api.core.IErrorState;
import forestry.core.access.EnumAccess;
import forestry.core.access.FakeAccessHandler;
import forestry.core.access.IAccessHandler;
import forestry.core.access.IRestrictedAccess;
import forestry.core.gui.ContainerForestry;
import forestry.core.network.ForestryPacket;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.packets.PacketAccessUpdate;
import forestry.core.network.packets.PacketErrorUpdate;
import forestry.core.network.packets.PacketGuiEnergy;
import forestry.core.network.packets.PacketGuiUpdate;
import forestry.core.network.packets.PacketTileConfiguration;
import forestry.core.tiles.IConfigurable;
import forestry.core.tiles.IPowerHandler;
import forestry.core.tiles.TilePowered;
import forestry.core.tiles.TileUtil;
import forestry.energy.EnergyManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.tileentity.TileEntity;

public abstract class ContainerTile<T extends TileEntity>
extends ContainerForestry {
    protected final T tile;
    private final IAccessHandler accessHandler;
    private boolean configurationChanged;
    private ImmutableSet<IErrorState> previousErrorStates;
    private int previousEnergyManagerData = 0;
    private EnumAccess previousAccess;
    private int previousWorkCounter = 0;
    private int previousTicksPerWorkCycle = 0;

    protected ContainerTile(T tile) {
        this.tile = tile;
        this.accessHandler = tile instanceof IRestrictedAccess ? ((IRestrictedAccess)tile).getAccessHandler() : FakeAccessHandler.getInstance();
        if (tile instanceof IConfigurable) {
            this.configurationChanged = true;
        }
    }

    protected ContainerTile(T tileForestry, InventoryPlayer playerInventory, int xInv, int yInv) {
        this(tileForestry);
        this.addPlayerInventory(playerInventory, xInv, yInv);
    }

    @Override
    protected final boolean canAccess(EntityPlayer player) {
        return player != null && this.accessHandler.allowsAlteration(player);
    }

    public final boolean func_75145_c(EntityPlayer entityplayer) {
        return TileUtil.isUsableByPlayer(entityplayer, this.tile) && this.accessHandler.allowsViewing(entityplayer);
    }

    public void func_75142_b() {
        IRestrictedAccess restrictedAccess;
        IAccessHandler accessHandler;
        EnumAccess access;
        EnergyManager energyManager;
        int energyManagerData;
        ForestryPacket packet;
        super.func_75142_b();
        if (this.tile instanceof IErrorLogicSource) {
            IErrorLogicSource errorLogicSource = (IErrorLogicSource)this.tile;
            ImmutableSet<IErrorState> errorStates = errorLogicSource.getErrorLogic().getErrorStates();
            if (this.previousErrorStates == null || !errorStates.equals(this.previousErrorStates)) {
                packet = new PacketErrorUpdate((TileEntity)this.tile, errorLogicSource);
                this.sendPacketToCrafters((IForestryPacketClient)((Object)packet));
            }
            this.previousErrorStates = errorStates;
        }
        if (this.tile instanceof IPowerHandler && (energyManagerData = (energyManager = ((IPowerHandler)this.tile).getEnergyManager()).toGuiInt()) != this.previousEnergyManagerData) {
            packet = new PacketGuiEnergy(this.field_75152_c, energyManagerData);
            this.sendPacketToCrafters((IForestryPacketClient)((Object)packet));
            this.previousEnergyManagerData = energyManagerData;
        }
        if (this.tile instanceof IRestrictedAccess && (access = (accessHandler = (restrictedAccess = (IRestrictedAccess)this.tile).getAccessHandler()).getAccess()) != this.previousAccess) {
            PacketAccessUpdate packet2 = new PacketAccessUpdate(restrictedAccess, (TileEntity)this.tile);
            this.sendPacketToCrafters(packet2);
            this.previousAccess = access;
        }
        if (this.tile instanceof TilePowered) {
            int ticksPerWorkCycle;
            boolean guiNeedsUpdate = false;
            TilePowered tilePowered = (TilePowered)this.tile;
            int workCounter = tilePowered.getWorkCounter();
            if (workCounter != this.previousWorkCounter) {
                guiNeedsUpdate = true;
                this.previousWorkCounter = workCounter;
            }
            if ((ticksPerWorkCycle = tilePowered.getTicksPerWorkCycle()) != this.previousTicksPerWorkCycle) {
                guiNeedsUpdate = true;
                this.previousTicksPerWorkCycle = ticksPerWorkCycle;
            }
            if (guiNeedsUpdate) {
                PacketGuiUpdate packet3 = new PacketGuiUpdate(tilePowered);
                this.sendPacketToCrafters(packet3);
            }
        }
        if (this.tile instanceof IConfigurable && this.configurationChanged) {
            this.configurationChanged = false;
            this.sendPacketToCrafters(new PacketTileConfiguration((TileEntity)this.tile));
        }
    }

    protected void markConfigurationDirty() {
        this.configurationChanged = true;
    }

    public void onGuiEnergy(int energyStored) {
        if (this.tile instanceof IPowerHandler) {
            EnergyManager energyManager = ((IPowerHandler)this.tile).getEnergyManager();
            energyManager.fromGuiInt(energyStored);
        }
    }
}

